clearvars;
close all;

cm = [1]; %Cloning Methods
L = 80;
logt = 4;

ncvalues = [5,6];
reps = [10,1];
numvals = [101,11];
scale = [80,1];
intervals=50./(numvals-1);
colours={[0 0.5 0],[0 0 0]};
markers={'o','x'};
msize=[5,7];

for j=1:size(ncvalues,2);
kave=zeros(1,numvals(j));
sLLarray=zeros(1,numvals(j));
for n=1:size(cm,2)
for m = 0:numvals(j)-1
seed = 0;
lognc=ncvalues(j);
dt = 10;
sLL = m*intervals(j);

filename=sprintf('0,K,%d,%d,%d,%0.1f.mat',logt,lognc,L,sLL);
load(filename);

sLLarray(m+1) = sLL;
kave(m+1) = mean(K)/scale(j);
end
end

hold on,plot(sLLarray,kave,markers{j},'Color',colours{j},'MarkerSize',msize(j),'LineWidth',1.8);
end

load('K.mat');
hold on,plot(K(:,2),K(:,1),'k-','LineWidth',2.4);

xlim([0,50]);
ylim([0,0.6]);

set(gca, 'FontSize', 32);
set(gca,'linewidth',2);
xlabel('$\lambda$','FontSize',24,'interpreter','latex');
yname = '$\bar{k}(\lambda)_{\mathrm{n_c,t_{obs}}}$';
ylabel(yname,'FontSize',24,'interpreter','latex');
set(gca,'XTick', [0,20,40]);
set(gca,'YTick', [0,0.2,0.4]);

hold on, plot(6,0.25,'o','Color',colours{1},'MarkerSize',7,'LineWidth',1.8);
text(9,0.25,'$n_c=10^5$','FontSize',24,'interpreter','latex');
hold on, plot(6,0.16,'x','Color',colours{2},'MarkerSize',12,'LineWidth',1.8);
text(9,0.16,'$n_c=10^6$','FontSize',24,'interpreter','latex');
hold on, plot([3.8,7.1],[0.07,0.07],'k-','LineWidth',3.2);
text(9,0.07,'Theory','FontSize',24,'interpreter','latex');

set(gcf,'units','points','position',[10,10,400,300]);
set(gca, 'FontSize',24);
set(gca,'linewidth',2);

plotname = sprintf('ncConv.png');
saveas(gcf,plotname);